(function(window, $) {
    $(function() {
        var bEffectNone = function() {},
        bEffectFade = function() {
            this.wrap = null;
            this.list = null;
            this.animation = false;
            this.current = 0; //1始まり。1～n
            return this.init();
        };
        bEffectFade.prototype = {
            
            //初期化処理
            init: function() {
                this.wrap = $("#coverWrap");
                this.list = this.wrap.find('>*');
                this.loaded = 0;
                this.length = this.list.length;

                return this;
            },
            setPosition: function() {
                return this;
            },
            start: function() {
                var self = this;
                var defer = $.Deferred();
                var sid = null;
                
                self.setPosition();

                this.list.find('img').each(function(){
                    if(0 < $(this).height()) {
                        self.loaded++;
                    } else {
                        $(this).on('load', function(){
                            self.loaded++;
                        });
                    }
                });

                sid = setInterval(function(){
                    if(self.loaded == self.length) {
                        defer.resolve();
                    }
                }, 10);
                
                defer.promise().done(function(){
                    clearInterval(sid);
                    // self.list = self.rsort(self.list);
                    self.list.each(function(){
                        var src = $(this).find('img').attr('src');
                        $(this).css({backgroundImage: 'url('+src+')' });
                        $(this).find('img').hide();
                    });
                    
                    self.wrap.find('~#coverLeft, ~#coverRight').show();
                });
                this.current = this.length;
                this.navi();
                if(1 < this.list.length) {
                    this.fade();
                }
                
                window.bEffects = this;
                return this;
            },
            reset: function() {
                this.wrap = $("#coverWrap");
                this.list = this.wrap.find('>*');
                this.length = this.list.length;
                this.loaded = this.length;

                this.list.each(function(){
                    var src = $(this).find('img').attr('src');
                    $(this).css({backgroundImage: 'url('+src+')' });
                    $(this).find('img').hide();
                });
                
                this.wrap.find('~#coverLeft, ~#coverRight').show();
                this.navi();
                if(1 < this.list.length) {
                    this.fade();
                }

                return this;
            },
            stop: function() {
                return this;
            },
            fade: function(zero, reverse) {
                var self = this;
                var anim = function(reverse){
                    if(coverAutoID) {
                        clearTimeout(coverAutoID);
                    }
                    coverAutoID = setTimeout(function() {
                        var list = self.wrap.find(">*");
                        var active = self.wrap.find(">*:eq("+(self.current-1)+")");
                        var next = null;
                        
                        if(reverse === true) {
                            //前
                            if(list.length-1 < self.current) {
                                next = self.wrap.find(">*:eq(0)");
                            } else {
                                next = self.wrap.find(">*:eq("+(self.current)+")");
                            }
                            
                            self.current++;
                            if(list.length < self.current) {
                                self.current = 1;
                            }
                        } else {
                            //次
                            if(self.current-2 < 0) {
                                next = self.wrap.find(">*:eq("+(list.length-1)+")");
                            } else {
                                next = self.wrap.find(">*:eq("+(self.current-2)+")");
                            }
                            
                            self.current--;
                            if(self.current <= 0) {
                                self.current = list.length;
                            }
                        }
                        $(self).trigger('onSlideChange');
                        self.scaleUp(next, cover_interval+cover_duration+cover_duration+200);
                        $.when(
                            active.fadeOut(cover_duration),
                            next.fadeIn(cover_duration)
                        ).done(function(){
                            active.css({transform: ''});
                            active.css({'transform-origin': ''});
                            anim();
                        });
                        
                    }, zero||cover_interval);
                    zero = null;
                }
                
                self.scaleUp(self.wrap.find(">*").last(), cover_interval+cover_duration+200);
                anim(reverse);
            },
            fadeTo: function(toIndex) {
                var self = this;
                var active = self.wrap.find(">*:eq("+(self.current-1)+")");
                var next = self.wrap.find(">*:eq("+(toIndex-1)+")");
                
                if(self.current == toIndex) {
                    return;
                }
                
                if(coverAutoID) {
                    clearTimeout(coverAutoID);
                }
                
                for(var i = Math.min(toIndex, self.current); i < Math.max(toIndex, self.current) - 1; i++ ) {
                    self.wrap.find(">*:eq("+(i)+")").hide();
                }
            
                self.current = toIndex;
                self.scaleUp(next, cover_interval+cover_duration+cover_duration+200);
                $.when(
                    active.fadeOut(cover_duration),
                    next.fadeIn(cover_duration)
                ).done(function(){
                    active.css({transform: ''});
                    active.css({'transform-origin': ''});
                    self.fade(cover_interval);
                });
            },
            scaleUp: function(element, duration, start, rate) {
                var self = this;
                var position = [
                    "left top", "center top", "right top",
                    "left center", "center", "right center",
                    "left bottom", "center bottom", "right bottom"
                ];
                var posNo = Math.round(Math.random() * 8);
                var scale = [[1, 1.06], [1.06,1]];
                var scaleNo = Math.round(Math.random() * 1);
                var a = scale[scaleNo];
                
                if(duration == null) {
                    duration = 0;
                }
                if(start == null) {
                    start = a[0];
                }
                if(rate == null) {
                    rate = a[1];
                }

                element.css({'transform-origin': position[posNo]});
                
                $.Animation({rate:start}, {rate:rate}, {duration: duration, easing: "linear"}).progress(function() {
                    element.css({transform: 'scale3d('+this.rate+', '+this.rate+', 1)'});
                });
            },
            navi: function() {
                var self = this;
                if(1 < self.wrap.find(">*").length) {
                    //左右アロー
                    this.wrap.find('~#coverRight').on('click', function(){
                        self.next();
                    });
                    this.wrap.find('~#coverLeft').on('click', function(){
                        self.prev();
                    });
                    //bullet
                    this.bullet();
                } else {
                    //左右アロー
                    this.wrap.find('~#coverRight, ~#coverLeft').hide();
                    //bullet
                    this.wrap.find('~.nav').hide();
                }
            },
            next: function() {
                if(coverAutoID) {
                    clearTimeout(coverAutoID);
                }
                
                this.wrap.find('>*').stop(true, true);
                this.fade(5);
            },
            prev: function() {
                if(coverAutoID) {
                    clearTimeout(coverAutoID);
                }
                
                this.wrap.find('>*').stop(true, true);
                this.fade(5, true);
            },
            bullet: function() {
                var self = this;
                var nav = this.wrap.find('~.nav');
                if(0 == nav.length) {
                    return;
                }
                
                nav.find('a').off('click');
                nav.find('a').each(function(idx) {
                    (function(a, idx, max){
                        $(a).on('click', function() {
                            nav.find('a.active').removeClass('active');
                            $(this).addClass('active');
                            self.fadeTo(max-idx);
                        });
                    })(this, idx, nav.find('a').length);
                });
                
                $(self).on('onSlideChange', function() {
                    nav.find('a.active').removeClass('active');
                    nav.find('a:eq('+(nav.find('a').length - self.current)+')').addClass('active');
                    
                });
                
                return;
            },
            rsort: function(list) {
                var _tmp = [];
                for(var i = list.length-1; 0 <= i; i--) {
                    _tmp.push(list[i]);
                }
                
                return $(_tmp);
            }
        };
        
        bEffectNone.prototype = bEffectFade.prototype;
        
        window.bEffectFade = new bEffectFade();
        window.bEffectNone = new bEffectNone();
        
        
        $(document).trigger("bCoverReady");

    });

})(window, jQuery);